/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.customizableelytra.items;

import com.hidoni.customizableelytra.config.Config;
import com.hidoni.customizableelytra.util.ElytraCustomizationUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CustomizableElytraItem
extends ElytraItem
implements DyeableLeatherItem {
    public static final String LEFT_WING_TRANSLATION_KEY = "item.customizableelytra.left_wing";
    public static final String RIGHT_WING_TRANSLATION_KEY = "item.customizableelytra.right_wing";
    public static final String HIDDEN_CAPE_TRANSLATION_KEY = "item.customizableelytra.cape_hidden";
    public static final String GLOWING_WING_TRANSLATION_KEY = "item.customizableelytra.glowing_wing";

    public CustomizableElytraItem(Item.Properties builder) {
        super(builder);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static ResourceLocation getTextureLocation(BannerPattern bannerIn) {
        if (((Boolean)Config.useLowQualityElytraBanners.get()).booleanValue()) {
            return new ResourceLocation("customizableelytra", "entity/elytra_banner_low/" + bannerIn.m_58572_());
        }
        return new ResourceLocation("customizableelytra", "entity/elytra_banner/" + bannerIn.m_58572_());
    }

    public int m_41121_(ItemStack stack) {
        return this.getColor(stack, 0);
    }

    public int getColor(ItemStack stack, int index) {
        return ElytraCustomizationUtil.getData((ItemStack)stack).handler.getColor(index);
    }

    public boolean m_41113_(ItemStack stack) {
        CompoundTag bannerTag = stack.m_41737_("BlockEntityTag");
        CompoundTag wingTag = stack.m_41737_("WingInfo");
        return super.m_41113_(stack) || bannerTag != null || wingTag != null || stack.m_41784_().m_128471_("HideCapePattern") || stack.m_41784_().m_128451_("WingLightLevel") > 0;
    }

    public void m_41123_(ItemStack stack) {
        super.m_41123_(stack);
        stack.m_41784_().m_128473_("HideCapePattern");
        stack.m_41784_().m_128473_("WingLightLevel");
        stack.m_41749_("BlockEntityTag");
        stack.m_41749_("WingInfo");
    }

    @Nullable
    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.CHEST;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        CustomizableElytraItem.applyTooltip(tooltip, flagIn, stack.m_41783_(), true);
        CompoundTag wingInfo = stack.m_41737_("WingInfo");
        if (wingInfo != null) {
            CompoundTag rightWing;
            CompoundTag leftWing;
            if (wingInfo.m_128441_("left") && !(leftWing = wingInfo.m_128469_("left")).m_128456_()) {
                tooltip.add((Component)new TranslatableComponent(LEFT_WING_TRANSLATION_KEY).m_130940_(ChatFormatting.GRAY));
                CustomizableElytraItem.applyTooltip(tooltip, flagIn, leftWing);
            }
            if (wingInfo.m_128441_("right") && !(rightWing = wingInfo.m_128469_("right")).m_128456_()) {
                tooltip.add((Component)new TranslatableComponent(RIGHT_WING_TRANSLATION_KEY).m_130940_(ChatFormatting.GRAY));
                CustomizableElytraItem.applyTooltip(tooltip, flagIn, rightWing);
            }
        }
    }

    public String m_5524_() {
        return Items.f_42741_.m_5524_();
    }

    public static void applyTooltip(List<Component> tooltip, TooltipFlag flagIn, CompoundTag wingIn) {
        CustomizableElytraItem.applyTooltip(tooltip, flagIn, wingIn, false);
    }

    public static void applyTooltip(List<Component> tooltip, TooltipFlag flagIn, CompoundTag wingIn, boolean ignoreDisplayTag) {
        CompoundTag wing = ElytraCustomizationUtil.migrateOldSplitWingFormat(wingIn);
        if (wing.m_128471_("HideCapePattern")) {
            tooltip.add((Component)new TranslatableComponent(HIDDEN_CAPE_TRANSLATION_KEY).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        }
        if (wing.m_128451_("WingLightLevel") > 0) {
            tooltip.add((Component)new TranslatableComponent(GLOWING_WING_TRANSLATION_KEY).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
        }
        if (!ignoreDisplayTag && wing.m_128441_("display")) {
            CompoundTag displayTag = wing.m_128469_("display");
            if (displayTag.m_128425_("color", 99)) {
                if (flagIn.m_7050_()) {
                    tooltip.add((Component)new TranslatableComponent("item.color", new Object[]{String.format("#%06X", displayTag.m_128451_("color"))}).m_130940_(ChatFormatting.GRAY));
                } else {
                    tooltip.add((Component)new TranslatableComponent("item.dyed").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
                }
            }
        } else if (wing.m_128441_("BlockEntityTag")) {
            CompoundTag blockEntityTag = wingIn.m_128469_("BlockEntityTag");
            int baseColor = blockEntityTag.m_128451_("Base");
            tooltip.add((Component)new TranslatableComponent("block.minecraft.banner." + BannerPattern.BASE.m_58572_() + "." + DyeColor.m_41053_((int)baseColor).m_41065_()).m_130940_(ChatFormatting.GRAY));
            ListTag listnbt = blockEntityTag.m_128437_("Patterns", 10);
            for (int i = 0; i < listnbt.size() && i < 6; ++i) {
                CompoundTag patternNBT = listnbt.m_128728_(i);
                DyeColor dyecolor = DyeColor.m_41053_((int)patternNBT.m_128451_("Color"));
                BannerPattern bannerpattern = BannerPattern.m_58575_((String)patternNBT.m_128461_("Pattern"));
                if (bannerpattern == null) continue;
                tooltip.add((Component)new TranslatableComponent("block.minecraft.banner." + bannerpattern.m_58572_() + "." + dyecolor.m_41065_()).m_130940_(ChatFormatting.GRAY));
            }
        }
    }
}

